function zad3 ()
clear; 
hold on;
fplot( '4*exp(x)', [-2, 2], 'b' );
fplot( '5*(x+1)', [-2, 2], 'r' );
hold off;


eps = input( 'Unesite zeljenu tacnost:\n' );
ispisi = 1;
% iterativna metoda
a_1 = -0.7;
b_1 = -0.2;
q_1 = 0.6550;
k_zaustavljanja_1 = (1 - q_1)./q_1 * eps;

a_2 = 0.5;
b_2 = 1;
q_2 = 0.5;
k_zaustavljanja_2 = (1 - q_2)./q_2 * eps;

disp( 'Resenja dobijena metodom proste iteracije: ' );
br_iteracija = iterativna_metoda( a_1, b_1, k_zaustavljanja_1, 1, ispisi )
br_iteracija = iterativna_metoda( a_2, b_2, k_zaustavljanja_2, 0, ispisi )

%modifikovana iterativna metoda
M_1 = -3.0137;
m_1 = -1.7251;
p_1 = (M_1 - m_1)./(M_1 + m_1);
k_mod_zaustavljanja_1 = (1 - p_1)./p_1 * eps;
lambda_1 = 2./(M_1 + m_1);

M_2 = 5.8731;
m_2 = 1.5949;
p_2 = (M_2 - m_2)./(M_2 + m_2);
k_mod_zaustavljanja_2 = (1 - p_2)./p_2 * eps;
lambda_2 = 2./(M_2 + m_2);

disp( 'Resenja dobijena modifikovanom iterativnom metodom: ' );
br_iteracija = modifikovana_iterativna_metoda ( a_1, b_1, lambda_1, k_mod_zaustavljanja_1, ispisi )
br_iteracija = modifikovana_iterativna_metoda ( a_2, b_2, lambda_2, k_mod_zaustavljanja_2, ispisi )

% graficki prikaz zavisnosti brzine konvergencije od trazene tacnosti
ispisi = 0;
tacnost = 0.0000001:4*0.0000001:0.001;
n = length(tacnost);
 for i=1:n
   k_zaustavljanja_1 = (1 - q_1)./q_1 * tacnost(i);
   k_zaustavljanja_2 = (1 - q_2)./q_2 * tacnost(i);
   br_iteracija_1(i) = iterativna_metoda( a_1, b_1, k_zaustavljanja_1, 1, ispisi );
   br_iteracija_2(i) = iterativna_metoda( a_2, b_2, k_zaustavljanja_2, 0, ispisi );

   k_mod_zaustavljanja_1 = (1 - p_1)./p_1 * tacnost(i);
   k_mod_zaustavljanja_2 = (1 - p_2)./p_2 * tacnost(i);
   br_mod_iteracija_1(i) = modifikovana_iterativna_metoda( a_1, b_1, lambda_1, k_mod_zaustavljanja_1, ispisi );
   br_mod_iteracija_2(i) = modifikovana_iterativna_metoda( a_2, b_2, lambda_2, k_mod_zaustavljanja_2, ispisi );
end
 
plot( br_iteracija_1,tacnost, '--r' );
hold on
plot( br_iteracija_2,tacnost, '--b' );
plot( br_mod_iteracija_1,tacnost, 'r' );
plot( br_mod_iteracija_2,tacnost, 'b' );

function br_iteracija = iterativna_metoda( a, b, k_zaustavljanja, nula, ispisi)
x_0 = (a + b)/2;
x_1 = 0;
br_iteracija = 0;
while( 1 )
    if( nula )
        x_1 = 4/5*exp(x_0) - 1; % za prvu nulu
    else
        x_1 = log((5/4)*(x_0 + 1) ); % za drugu nulu
    end
    
    if( abs(x_1 - x_0) < k_zaustavljanja )
        break;
    else
        br_iteracija = br_iteracija + 1;
        x_0 = x_1;
    end
end
if( ispisi )
    trazeno_x = x_1
end

function br_iteracija = modifikovana_iterativna_metoda( a, b, lambda, k_zaustavljanja, ispisi )
x_0 = (a+b)/2;
x_1 = 0;
br_iteracija = 0;
while( 1 )
    x_1 = x_0 - lambda * (4*exp(x_0) - 5*(x_0 + 1));
    if( abs(x_1 - x_0) < k_zaustavljanja )
        break;
    else
        br_iteracija = br_iteracija + 1;
        x_0 = x_1;
    end
end
if( ispisi )
    trazeno_x = x_1
end